/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Configuration;
import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.CoordinateLine;
import com.sothawo.mapjfx.CoordinateLineListener;
import com.sothawo.mapjfx.Extent;
import com.sothawo.mapjfx.MapCoordinateElement;
import com.sothawo.mapjfx.MapCoordinateElementListener;
import com.sothawo.mapjfx.MapLabel;
import com.sothawo.mapjfx.MapType;
import com.sothawo.mapjfx.Marker;
import com.sothawo.mapjfx.WMSParam;
import com.sothawo.mapjfx.XYZParam;
import com.sothawo.mapjfx.event.ClickType;
import com.sothawo.mapjfx.event.MapLabelEvent;
import com.sothawo.mapjfx.event.MapViewEvent;
import com.sothawo.mapjfx.event.MarkerEvent;
import com.sothawo.mapjfx.offline.OfflineCache;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventType;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapView
extends Region
implements AutoCloseable {
    public static final int MIN_ZOOM = 0;
    public static final int MAX_ZOOM = 28;
    public static final int INITIAL_ZOOM = 14;
    private static final Logger logger = LoggerFactory.getLogger(MapView.class);
    private static final String MAPVIEW_HTML = "/mapview.html";
    private static final String MAP_VIEW_NOT_YET_INITIALIZED = "MapView not yet initialized";
    private static final int NUM_RETRIES_FOR_JS = 10;
    private static final String CUSTOM_MAPVIEW_CSS = "custom_mapview.css";
    private final ReadOnlyBooleanWrapper initialized = new ReadOnlyBooleanWrapper(false);
    private final AtomicBoolean mapViewReady = new AtomicBoolean(false);
    private final AtomicReference<Coordinate> lastCoordinateFromMap = new AtomicReference();
    private final AtomicReference<Long> lastZoomFromMap = new AtomicReference();
    private final Map<String, WeakReference<MapCoordinateElement>> mapCoordinateElements = new HashMap<String, WeakReference<MapCoordinateElement>>();
    private final Map<String, MapCoordinateElementListener> mapCoordinateElementListeners = new HashMap<String, MapCoordinateElementListener>();
    private final Map<String, WeakReference<CoordinateLine>> coordinateLines = new HashMap<String, WeakReference<CoordinateLine>>();
    private final Map<String, CoordinateLineListener> coordinateLineListeners = new HashMap<String, CoordinateLineListener>();
    private final ReferenceQueue<Object> weakReferenceQueue = new ReferenceQueue();
    private final ConcurrentHashMap<URL, String> imgCache = new ConcurrentHashMap();
    private final OfflineCache offlineCache = OfflineCache.INSTANCE;
    private final JavaConnector javaConnector = new JavaConnector();
    private WebEngine webEngine;
    private SimpleObjectProperty<Coordinate> center;
    private SimpleDoubleProperty zoom;
    private SimpleIntegerProperty animationDuration;
    private SimpleObjectProperty<MapType> mapType;
    private JSObject jsMapView;
    private Pattern htmlIncludePattern = Pattern.compile("^#(.+)#$");
    private Optional<String> bingMapsApiKey = Optional.empty();
    private Optional<URL> customMapviewCssURL = Optional.empty();
    private Optional<WMSParam> wmsParam = Optional.empty();
    private Optional<XYZParam> xyzParam = Optional.empty();
    private Thread weakRefCleaner;

    public MapView() {
        this.initProperties();
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(Paint.valueOf((String)"#ccc"), null, null)}));
        this.startWeakRefCleaner();
    }

    @Override
    public void close() {
        this.stopWeakRefCleaner();
    }

    private void initProperties() {
        this.center = new SimpleObjectProperty();
        this.center.addListener((observable, oldValue, newValue) -> {
            if (newValue != this.lastCoordinateFromMap.get()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("center changed from {} to {}", oldValue, newValue);
                }
                this.setCenterInMap();
            }
        });
        this.zoom = new SimpleDoubleProperty(14.0);
        this.zoom.addListener((observable, oldValue, newValue) -> {
            Long rounded = Math.round((Double)newValue);
            if (!Objects.equals(rounded, this.lastZoomFromMap.get())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("zoom changed from {} to {}", oldValue, (Object)rounded);
                }
                this.setZoomInMap();
            }
        });
        this.animationDuration = new SimpleIntegerProperty(0);
        this.mapType = new SimpleObjectProperty((Object)MapType.OSM);
        this.mapType.addListener((observable, oldValue, newValue) -> {
            String url;
            if (logger.isTraceEnabled()) {
                logger.trace("map type changed from {} to {}", (Object)oldValue, (Object)newValue);
            }
            if (!this.checkApiKey((MapType)((Object)newValue))) {
                if (logger.isWarnEnabled()) {
                    logger.warn("no api key defined for map type {}", (Object)newValue);
                }
                this.mapType.set((Object)oldValue);
            }
            if (MapType.WMS == newValue) {
                boolean wmsValid = false;
                if (this.wmsParam.isPresent() && null != (url = this.wmsParam.get().getUrl()) && !url.isEmpty()) {
                    wmsValid = true;
                }
                if (!wmsValid) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("no wms params defined for map type {}", (Object)newValue);
                    }
                    this.mapType.set((Object)oldValue);
                }
            }
            if (MapType.XYZ.equals(newValue)) {
                boolean xyzValid = false;
                if (this.xyzParam.isPresent() && null != (url = this.xyzParam.get().getUrl()) && !url.isEmpty()) {
                    xyzValid = true;
                }
                if (!xyzValid) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("no xyz params defined for map type {}", (Object)newValue);
                    }
                    this.mapType.set((Object)oldValue);
                }
            }
            this.setMapTypeInMap();
        });
    }

    private synchronized void startWeakRefCleaner() {
        this.weakRefCleaner = new Thread(() -> {
            boolean running = true;
            while (running) {
                try {
                    this.weakReferenceQueue.remove();
                    HashSet coordinateLinesToRemove = new HashSet();
                    Map<String, WeakReference<CoordinateLine>> map = this.coordinateLines;
                    synchronized (map) {
                        this.coordinateLines.forEach((k, v) -> {
                            if (null == v.get()) {
                                coordinateLinesToRemove.add(k);
                                if (logger.isTraceEnabled()) {
                                    logger.trace("need to cleanup gc'ed coordinate line {}", k);
                                }
                            }
                        });
                    }
                    Platform.runLater(() -> coordinateLinesToRemove.forEach(this::removeCoordinateLineWithId));
                    HashSet mapCoordinateElementsToRemove = new HashSet();
                    Map<String, WeakReference<MapCoordinateElement>> map2 = this.mapCoordinateElements;
                    synchronized (map2) {
                        this.mapCoordinateElements.forEach((k, v) -> {
                            if (null == v.get()) {
                                mapCoordinateElementsToRemove.add(k);
                                if (logger.isTraceEnabled()) {
                                    logger.trace("need to cleanup gc'ed element {}", k);
                                }
                            }
                        });
                    }
                    Platform.runLater(() -> mapCoordinateElementsToRemove.forEach(this::removeMapCoordinateElementWithId));
                }
                catch (InterruptedException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("thread interrupted");
                    }
                    running = false;
                }
            }
        });
        this.weakRefCleaner.setName("MapView-WeakRef-Cleaner");
        this.weakRefCleaner.setDaemon(true);
        this.weakRefCleaner.start();
    }

    private synchronized void stopWeakRefCleaner() {
        if (this.weakRefCleaner != null) {
            this.weakRefCleaner.interrupt();
            this.weakRefCleaner = null;
        }
    }

    private void setCenterInMap() {
        Coordinate actCenter = this.getCenter();
        if (this.getInitialized() && null != actCenter) {
            if (logger.isTraceEnabled()) {
                logger.trace("setting center in OpenLayers map: {}, animation: {}", (Object)actCenter, (Object)this.animationDuration.get());
            }
            this.jsMapView.call("setCenter", actCenter.getLatitude(), actCenter.getLongitude(), this.animationDuration.get());
        }
    }

    private void setZoomInMap() {
        if (this.getInitialized()) {
            int zoomInt = (int)this.getZoom();
            if (logger.isTraceEnabled()) {
                logger.trace("setting zoom in OpenLayers map: {}, animation: {}", (Object)zoomInt, (Object)this.animationDuration.get());
            }
            this.jsMapView.call("setZoom", zoomInt, this.animationDuration.get());
        }
    }

    private boolean checkApiKey(MapType mapTypeToCheck) {
        switch (Objects.requireNonNull(mapTypeToCheck)) {
            case BINGMAPS_ROAD: 
            case BINGMAPS_AERIAL: 
            case BINGMAPS_AERIAL_WITH_LABELS: 
            case BINGMAPS_CANVAS_DARK: 
            case BINGMAPS_CANVAS_GRAY: 
            case BINGMAPS_CANVAS_LIGHT: {
                return this.bingMapsApiKey.isPresent();
            }
        }
        return true;
    }

    private void setMapTypeInMap() {
        if (this.getInitialized()) {
            String mapTypeName = this.getMapType().toString();
            if (logger.isDebugEnabled()) {
                logger.debug("setting map type in OpenLayers map: {}", (Object)mapTypeName);
            }
            this.bingMapsApiKey.ifPresent(apiKey -> this.jsMapView.call("setBingMapsApiKey", apiKey));
            this.wmsParam.ifPresent(wmsParam -> {
                this.jsMapView.call("newWMSParams", new Object[0]);
                this.jsMapView.call("setWMSParamsUrl", wmsParam.getUrl());
                wmsParam.getParams().forEach((key, value) -> this.jsMapView.call("addWMSParamsParams", key, value));
            });
            this.xyzParam.ifPresent(xyzParam -> this.jsMapView.call("setXYZParams", xyzParam.toJSON()));
            this.jsMapView.call("setMapType", mapTypeName);
        }
    }

    public Coordinate getCenter() {
        return (Coordinate)this.center.get();
    }

    public MapView setCenter(Coordinate center) {
        this.center.set((Object)center);
        return this;
    }

    public boolean getInitialized() {
        return this.mapViewReady.get() || this.initialized.get();
    }

    public double getZoom() {
        return this.zoom.get();
    }

    public MapView setZoom(double zoom) {
        double rounded = Math.round(zoom);
        if (rounded < 0.0 || rounded > 28.0) {
            return this;
        }
        this.zoom.set(rounded);
        return this;
    }

    public MapType getMapType() {
        return (MapType)((Object)this.mapType.get());
    }

    public MapView setMapType(MapType mapType) {
        this.mapType.set((Object)mapType);
        return this;
    }

    public OfflineCache getOfflineCache() {
        return this.offlineCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapView addCoordinateLine(CoordinateLine coordinateLine) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            Map<String, WeakReference<CoordinateLine>> map = this.coordinateLines;
            synchronized (map) {
                String id = Objects.requireNonNull(coordinateLine).getId();
                if (!this.coordinateLines.containsKey(id)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("adding coordinate line {}", (Object)coordinateLine);
                    }
                    JSObject jsCoordinateLine = (JSObject)this.jsMapView.call("getCoordinateLine", id);
                    coordinateLine.getCoordinateStream().forEach(coord -> jsCoordinateLine.call("addCoordinate", coord.getLatitude(), coord.getLongitude()));
                    Color color = coordinateLine.getColor();
                    jsCoordinateLine.call("setColor", color.getRed() * 255.0, color.getGreen() * 255.0, color.getBlue() * 255.0, color.getOpacity());
                    Color fillColor = coordinateLine.getFillColor();
                    jsCoordinateLine.call("setFillColor", fillColor.getRed() * 255.0, fillColor.getGreen() * 255.0, fillColor.getBlue() * 255.0, fillColor.getOpacity());
                    jsCoordinateLine.call("setWidth", coordinateLine.getWidth());
                    jsCoordinateLine.call("setClosed", coordinateLine.isClosed());
                    jsCoordinateLine.call("seal", new Object[0]);
                    ChangeListener changeListener = (observable, newValue, oldValue) -> this.setCoordinateLineVisibleInMap(id);
                    coordinateLine.visibleProperty().addListener(changeListener);
                    this.coordinateLineListeners.put(id, new CoordinateLineListener((ChangeListener<Boolean>)changeListener));
                    this.coordinateLines.put(id, new WeakReference<Object>(coordinateLine, this.weakReferenceQueue));
                    this.setCoordinateLineVisibleInMap(id);
                }
            }
        }
        return this;
    }

    private void setCoordinateLineVisibleInMap(String coordinateLineId) {
        CoordinateLine coordinateLine;
        WeakReference<CoordinateLine> coordinateLineWeakReference;
        if (null != coordinateLineId && null != (coordinateLineWeakReference = this.coordinateLines.get(coordinateLineId)) && null != (coordinateLine = (CoordinateLine)coordinateLineWeakReference.get())) {
            if (coordinateLine.getVisible()) {
                this.jsMapView.call("showCoordinateLine", coordinateLineId);
            } else {
                this.jsMapView.call("hideCoordinateLine", coordinateLineId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapView addLabel(MapLabel mapLabel) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            if (null == Objects.requireNonNull(mapLabel).getPosition()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("label with no position was not added: {}", (Object)mapLabel);
                }
                return this;
            }
            String id = mapLabel.getId();
            Map<String, WeakReference<MapCoordinateElement>> map = this.mapCoordinateElements;
            synchronized (map) {
                if (mapLabel.getMarker().isPresent() && !this.mapCoordinateElements.containsKey(mapLabel.getMarker().get().getId())) {
                    return this;
                }
                if (!this.mapCoordinateElements.containsKey(id)) {
                    this.addMapCoordinateElement(mapLabel);
                    this.jsMapView.call("addLabel", id, mapLabel.getText(), mapLabel.getCssClass(), mapLabel.getPosition().getLatitude(), mapLabel.getPosition().getLongitude(), mapLabel.getOffsetX(), mapLabel.getOffsetY());
                    if (logger.isTraceEnabled()) {
                        logger.trace("add label in OpenLayers map {}", (Object)mapLabel);
                    }
                    this.setMarkerVisibleInMap(id);
                }
            }
        }
        return this;
    }

    private void addMapCoordinateElement(MapCoordinateElement mapCoordinateElement) {
        String id = mapCoordinateElement.getId();
        ChangeListener coordinateChangeListener = (observable, oldValue, newValue) -> this.moveMapCoordinateElementInMap(id);
        ChangeListener visibileChangeListener = (observable, oldValue, newValue) -> this.setMarkerVisibleInMap(id);
        ChangeListener cssChangeListener = (observable, oldValue, newValue) -> this.setMapCoordinateElementCss(id, (String)newValue);
        this.mapCoordinateElementListeners.put(id, new MapCoordinateElementListener((ChangeListener<Coordinate>)coordinateChangeListener, (ChangeListener<Boolean>)visibileChangeListener, (ChangeListener<String>)cssChangeListener));
        mapCoordinateElement.positionProperty().addListener(coordinateChangeListener);
        mapCoordinateElement.visibleProperty().addListener(visibileChangeListener);
        mapCoordinateElement.cssClassProperty().addListener(cssChangeListener);
        this.mapCoordinateElements.put(id, new WeakReference<Object>(mapCoordinateElement, this.weakReferenceQueue));
    }

    private void setMapCoordinateElementCss(String id, String cssclass) {
        this.jsMapView.call("setLabelCss", id, cssclass);
    }

    private void setMarkerVisibleInMap(String id) {
        MapCoordinateElement mapCoordinateElement;
        WeakReference<MapCoordinateElement> weakReference;
        if (null != id && null != (weakReference = this.mapCoordinateElements.get(id)) && null != (mapCoordinateElement = (MapCoordinateElement)weakReference.get())) {
            if (mapCoordinateElement.getVisible()) {
                this.jsMapView.call("showMapObject", mapCoordinateElement.getId());
            } else {
                this.jsMapView.call("hideMapObject", mapCoordinateElement.getId());
            }
        }
    }

    private void moveMapCoordinateElementInMap(String id) {
        MapCoordinateElement mapCoordinateElement;
        WeakReference<MapCoordinateElement> weakReference;
        if (this.getInitialized() && null != id && null != (weakReference = this.mapCoordinateElements.get(id)) && null != (mapCoordinateElement = (MapCoordinateElement)weakReference.get())) {
            if (logger.isTraceEnabled()) {
                logger.trace("move element in OpenLayers map to {}", (Object)mapCoordinateElement);
            }
            this.jsMapView.call("moveMapObject", mapCoordinateElement.getId(), mapCoordinateElement.getPosition().getLatitude(), mapCoordinateElement.getPosition().getLongitude());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapView addMarker(Marker marker) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            if (null == Objects.requireNonNull(marker).getPosition()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("marker with no position was not added: {}", (Object)marker);
                }
                return this;
            }
            String id = marker.getId();
            Map<String, WeakReference<MapCoordinateElement>> map = this.mapCoordinateElements;
            synchronized (map) {
                if (!this.mapCoordinateElements.containsKey(id)) {
                    this.addMapCoordinateElement(marker);
                    this.jsMapView.call("addMarker", id, marker.getImageURL().toExternalForm(), marker.getPosition().getLatitude(), marker.getPosition().getLongitude(), marker.getOffsetX(), marker.getOffsetY());
                    if (logger.isTraceEnabled()) {
                        logger.trace("add marker in OpenLayers map {}", (Object)marker);
                    }
                    this.setMarkerVisibleInMap(id);
                }
            }
            marker.getMapLabel().ifPresent(this::addLabel);
        }
        return this;
    }

    public SimpleIntegerProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public SimpleObjectProperty<Coordinate> centerProperty() {
        return this.center;
    }

    private String createDataURI(URL imageURL) {
        return this.imgCache.computeIfAbsent(imageURL, url -> {
            String dataUrl;
            block43: {
                dataUrl = null;
                try (InputStream isGuess = url.openStream();
                     InputStream isConvert = url.openStream();
                     ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    String contentType = URLConnection.guessContentTypeFromStream(isGuess);
                    if (null != contentType) {
                        int bytesRead;
                        byte[] chunk = new byte[4096];
                        while ((bytesRead = isConvert.read(chunk)) > 0) {
                            os.write(chunk, 0, bytesRead);
                        }
                        os.flush();
                        dataUrl = "data:" + contentType + ";base64," + Base64.getEncoder().encodeToString(os.toByteArray());
                    } else if (logger.isWarnEnabled()) {
                        logger.warn("could not get content type from {}", (Object)imageURL.toExternalForm());
                    }
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) break block43;
                    logger.warn("error loading image", (Throwable)e);
                }
            }
            if (null == dataUrl && logger.isWarnEnabled()) {
                logger.warn("could not create data url from {}", (Object)imageURL.toExternalForm());
            }
            return dataUrl;
        });
    }

    public int getAnimationDuration() {
        return this.animationDuration.get();
    }

    public MapView setAnimationDuration(int animationDuration) {
        this.animationDuration.set(animationDuration);
        return this;
    }

    public void initialize() {
        this.initialize(Configuration.builder().build());
    }

    public void initialize(Configuration configuration) {
        if (logger.isDebugEnabled()) {
            logger.debug("initializing...");
            logger.debug(configuration.toString());
        }
        this.loadMapViewHtml().ifPresent(html -> {
            WebView webView = new WebView();
            if (logger.isTraceEnabled()) {
                logger.trace("WebView created");
            }
            this.webEngine = webView.getEngine();
            webView.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            webView.prefHeightProperty().bind((ObservableValue)this.heightProperty());
            this.getChildren().add((Object)webView);
            this.logVersions();
            webView.getEngine().setOnAlert(event -> {
                if (logger.isWarnEnabled()) {
                    logger.warn("JS alert: {}", event.getData());
                }
            });
            this.webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                if (logger.isTraceEnabled()) {
                    logger.trace("WebEngine loader state {} -> {}", oldValue, newValue);
                }
                if (Worker.State.SUCCEEDED == newValue) {
                    JSObject window = (JSObject)this.webEngine.executeScript("window");
                    window.setMember("_javaConnector", this.javaConnector);
                    this.webEngine.executeScript("console.log = function(msg) { _javaConnector.console(msg) }");
                    int numRetries = 0;
                    do {
                        try {
                            String script = "createJSMapView('" + configuration.toJson() + "')";
                            if (logger.isDebugEnabled()) {
                                logger.debug("calling JS \"" + script + '\"');
                            }
                            Object o = this.webEngine.executeScript(script);
                            this.jsMapView = (JSObject)o;
                        }
                        catch (JSException e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("JS not ready, retrying...");
                            }
                            ++numRetries;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e1) {
                                if (!logger.isWarnEnabled()) continue;
                                logger.warn("retry interrupted");
                            }
                        }
                        catch (Exception e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("getJSMapView: returned (null)");
                            }
                            ++numRetries;
                        }
                    } while (null == this.jsMapView && numRetries < 10);
                    if (null == this.jsMapView) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("error loading {}, JavaScript not ready.", (Object)MAPVIEW_HTML);
                        }
                    } else {
                        this.mapViewReady.set(true);
                        this.setMapTypeInMap();
                        this.setCenterInMap();
                        this.setZoomInMap();
                        this.initialized.set(true);
                        if (logger.isDebugEnabled()) {
                            logger.debug("initialized.");
                        }
                    }
                } else if (Worker.State.FAILED == newValue && logger.isWarnEnabled()) {
                    logger.warn("error loading {}", (Object)MAPVIEW_HTML);
                }
            });
            if (logger.isDebugEnabled()) {
                logger.debug("load html into WebEngine");
            }
            this.webEngine.loadContent(html);
        });
    }

    private Optional<String> loadMapViewHtml() {
        String mapViewHtml;
        block18: {
            mapViewHtml = null;
            URL mapviewURL = this.getClass().getResource(MAPVIEW_HTML);
            if (null == mapviewURL) {
                if (logger.isWarnEnabled()) {
                    logger.warn("resource not found: {}", (Object)MAPVIEW_HTML);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("loading from {}", (Object)mapviewURL.toExternalForm());
                }
                try (Stream<String> lines = new BufferedReader(new InputStreamReader(mapviewURL.openStream(), StandardCharsets.UTF_8)).lines();){
                    String baseURL = mapviewURL.toExternalForm();
                    String baseURLPath = baseURL.substring(0, baseURL.lastIndexOf(47) + 1);
                    mapViewHtml = lines.map(String::trim).map(line -> this.processHtmlLine(baseURLPath, (String)line)).flatMap(Collection::stream).collect(Collectors.joining("\n"));
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) break block18;
                    logger.warn("loading {}", (Object)mapviewURL.toExternalForm(), (Object)e);
                }
            }
        }
        return Optional.ofNullable(mapViewHtml);
    }

    private void logVersions() {
        if (logger.isDebugEnabled()) {
            logger.debug("Java Version:   {}", (Object)System.getProperty("java.runtime.version"));
            logger.debug("JavaFX Version: {}", (Object)System.getProperty("javafx.runtime.version"));
            logger.debug("OS:             {}, {}, {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
            logger.debug("User Agent:     {}", (Object)this.webEngine.getUserAgent());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> processHtmlLine(String baseURL, String line) {
        if ("<head>".equalsIgnoreCase(line)) {
            return Arrays.asList(line, "<base href=\"" + baseURL + "\">");
        }
        Matcher matcher = this.htmlIncludePattern.matcher(line);
        if (!matcher.matches()) return Collections.singletonList(line);
        String resource = baseURL + matcher.group(1);
        if (CUSTOM_MAPVIEW_CSS.equals(matcher.group(1))) {
            if (!this.customMapviewCssURL.isPresent()) return Collections.singletonList(line);
            if (logger.isTraceEnabled()) {
                logger.trace("loading custom mapview css from {}", (Object)this.customMapviewCssURL.get().toExternalForm());
            }
            try (Stream<String> lines2 = new BufferedReader(new InputStreamReader(this.customMapviewCssURL.get().openStream(), StandardCharsets.UTF_8)).lines();){
                List<String> list2 = lines2.filter(l -> !l.contains("<")).collect(Collectors.toList());
                return list2;
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) return Collections.singletonList(line);
                logger.warn("loading resource {}", (Object)resource, (Object)e);
                return Collections.singletonList(line);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("loading from {}", (Object)resource);
        }
        try (Stream<String> lines = new BufferedReader(new InputStreamReader(new URL(resource).openStream(), StandardCharsets.UTF_8)).lines();){
            List<String> list = lines.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            if (!logger.isWarnEnabled()) return Collections.singletonList(line);
            logger.warn("loading resource {}", (Object)resource, (Object)e);
        }
        return Collections.singletonList(line);
    }

    public ReadOnlyBooleanProperty initializedProperty() {
        return this.initialized.getReadOnlyProperty();
    }

    public SimpleObjectProperty<MapType> mapTypeProperty() {
        return this.mapType;
    }

    public MapView removeCoordinateLine(CoordinateLine coordinateLine) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            this.removeCoordinateLineWithId(Objects.requireNonNull(coordinateLine).getId());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCoordinateLineWithId(String id) {
        Map<String, WeakReference<CoordinateLine>> map = this.coordinateLines;
        synchronized (map) {
            if (this.coordinateLines.containsKey(id)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("removing coordinate line {}", (Object)id);
                }
                this.jsMapView.call("hideCoordinateLine", id);
                this.jsMapView.call("removeCoordinateLine", id);
                if (logger.isTraceEnabled()) {
                    logger.trace("removing coordinate line {}, after JS calls", (Object)id);
                }
                CoordinateLine coordinateLine = (CoordinateLine)this.coordinateLines.get(id).get();
                CoordinateLineListener coordinateLineListener = this.coordinateLineListeners.get(id);
                if (null != coordinateLine && null != coordinateLineListener) {
                    coordinateLine.visibleProperty().removeListener(coordinateLineListener.getVisibileChangeListener());
                }
                this.coordinateLineListeners.remove(id);
                this.coordinateLines.remove(id);
            }
        }
    }

    public MapView removeLabel(MapLabel mapLabel) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else if (!Objects.requireNonNull(mapLabel).getMarker().isPresent()) {
            this.removeMapCoordinateElement(mapLabel);
        }
        return this;
    }

    private void removeMapCoordinateElement(MapCoordinateElement mapCoordinateElement) {
        this.removeMapCoordinateElementWithId(Objects.requireNonNull(mapCoordinateElement).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMapCoordinateElementWithId(String id) {
        Map<String, WeakReference<MapCoordinateElement>> map = this.mapCoordinateElements;
        synchronized (map) {
            if (this.mapCoordinateElements.containsKey(id)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("removing element {}", (Object)id);
                }
                this.jsMapView.call("hideMapObject", id);
                this.jsMapView.call("removeMapObject", id);
                MapCoordinateElement element = (MapCoordinateElement)this.mapCoordinateElements.get(id).get();
                MapCoordinateElementListener markerListener = this.mapCoordinateElementListeners.get(id);
                if (null != element && null != markerListener) {
                    element.positionProperty().removeListener(markerListener.getCoordinateChangeListener());
                    element.visibleProperty().removeListener(markerListener.getVisibileChangeListener());
                    element.cssClassProperty().removeListener(markerListener.getCssChangeListener());
                }
                this.mapCoordinateElementListeners.remove(id);
                this.mapCoordinateElements.remove(id);
                if (logger.isDebugEnabled()) {
                    logger.debug("removed element {}", (Object)id);
                }
            }
        }
    }

    public MapView removeMarker(Marker marker) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            Objects.requireNonNull(marker).getMapLabel().ifPresent(this::removeMapCoordinateElement);
            this.removeMapCoordinateElement(marker);
        }
        return this;
    }

    public MapView setBingMapsApiKey(String apiKey) {
        this.bingMapsApiKey = null != apiKey && !apiKey.isEmpty() ? Optional.of(apiKey) : Optional.empty();
        return this;
    }

    public MapView setWMSParam(WMSParam wmsParam) {
        this.wmsParam = Optional.ofNullable(wmsParam);
        return this;
    }

    public MapView setXYZParam(XYZParam xyzParam) {
        this.xyzParam = Optional.ofNullable(xyzParam);
        return this;
    }

    public void setCustomMapviewCssURL(URL url) {
        Objects.requireNonNull(url);
        this.customMapviewCssURL = Optional.of(url);
    }

    public MapView setExtent(Extent extent) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            Objects.requireNonNull(extent);
            if (logger.isDebugEnabled()) {
                logger.debug("setting extent in OpenLayers map: {}, animation: ", (Object)extent, (Object)this.animationDuration.get());
            }
            this.jsMapView.call("setExtent", extent.getMin().getLatitude(), extent.getMin().getLongitude(), extent.getMax().getLatitude(), extent.getMax().getLongitude(), this.animationDuration.get());
        }
        return this;
    }

    public MapView constrainExtent(Extent extent) {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            Objects.requireNonNull(extent);
            if (logger.isDebugEnabled()) {
                logger.debug("constraining extent in OpenLayers map: {}: ", (Object)extent);
            }
            this.jsMapView.call("constrainExtent", extent.getMin().getLatitude(), extent.getMin().getLongitude(), extent.getMax().getLatitude(), extent.getMax().getLongitude());
        }
        return this;
    }

    public MapView clearConstrainExtent() {
        if (!this.getInitialized()) {
            if (logger.isWarnEnabled()) {
                logger.warn(MAP_VIEW_NOT_YET_INITIALIZED);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("clearing constraining extent in OpenLayers map.");
            }
            this.jsMapView.call("clearConstrainExtent", new Object[0]);
        }
        return this;
    }

    public SimpleDoubleProperty zoomProperty() {
        return this.zoom;
    }

    public class JavaConnector {
        private final Logger logger = LoggerFactory.getLogger(JavaConnector.class);

        public void centerMovedTo(double lat, double lon) {
            Coordinate newCenter = new Coordinate(lat, lon);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports center value {}", (Object)newCenter);
            }
            MapView.this.lastCoordinateFromMap.set(newCenter);
            MapView.this.setCenter(newCenter);
        }

        public void pointerMovedTo(double lat, double lon) {
            Coordinate coordinate = new Coordinate(lat, lon);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports pointer move {}", (Object)coordinate);
            }
            MapView.this.fireEvent(new MapViewEvent(MapViewEvent.MAP_POINTER_MOVED, coordinate));
        }

        public void debug(String msg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JS: {}", (Object)msg);
            }
        }

        public void console(String msg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JS Console: {}", (Object)msg);
            }
        }

        public void showLink(String href) {
            block7: {
                if (null != href && !href.isEmpty()) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("JS asks to browse to {}", (Object)href);
                    }
                    if (!Desktop.isDesktopSupported()) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("no desktop support for displaying {}", (Object)href);
                        }
                    } else {
                        try {
                            Desktop.getDesktop().browse(new URI(href));
                        }
                        catch (IOException | URISyntaxException e) {
                            if (!this.logger.isWarnEnabled()) break block7;
                            this.logger.warn("can't display {}", (Object)href, (Object)e);
                        }
                    }
                }
            }
        }

        public void singleClickAt(double lat, double lon) {
            Coordinate coordinate = new Coordinate(lat, lon);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports single click at {}", (Object)coordinate);
            }
            MapView.this.fireEvent(new MapViewEvent(MapViewEvent.MAP_CLICKED, coordinate));
        }

        public void contextClickAt(double lat, double lon) {
            Coordinate coordinate = new Coordinate(lat, lon);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports context click at {}", (Object)coordinate);
            }
            MapView.this.fireEvent(new MapViewEvent(MapViewEvent.MAP_RIGHTCLICKED, coordinate));
        }

        public void markerClicked(String name) {
            this.processMarkerClicked(name, ClickType.LEFT);
        }

        public void markerMouseDown(String name) {
            this.processMarkerClicked(name, ClickType.MOUSEDOWN);
        }

        public void markerMouseUp(String name) {
            this.processMarkerClicked(name, ClickType.MOUSEUP);
        }

        public void markerDoubleClicked(String name) {
            this.processMarkerClicked(name, ClickType.DOUBLE);
        }

        public void markerRightClicked(String name) {
            this.processMarkerClicked(name, ClickType.RIGHT);
        }

        public void markerEntered(String name) {
            this.processMarkerClicked(name, ClickType.ENTERED);
        }

        public void markerExited(String name) {
            this.processMarkerClicked(name, ClickType.EXITED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMarkerClicked(String name, ClickType clickType) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports marker {} clicked {}", (Object)name, (Object)clickType);
            }
            Map map = MapView.this.mapCoordinateElements;
            synchronized (map) {
                if (MapView.this.mapCoordinateElements.containsKey(name)) {
                    MapCoordinateElement mapCoordinateElement = (MapCoordinateElement)((WeakReference)MapView.this.mapCoordinateElements.get(name)).get();
                    EventType<MarkerEvent> eventType = null;
                    switch (clickType) {
                        case LEFT: {
                            eventType = MarkerEvent.MARKER_CLICKED;
                            break;
                        }
                        case DOUBLE: {
                            eventType = MarkerEvent.MARKER_DOUBLECLICKED;
                            break;
                        }
                        case RIGHT: {
                            eventType = MarkerEvent.MARKER_RIGHTCLICKED;
                            break;
                        }
                        case MOUSEDOWN: {
                            eventType = MarkerEvent.MARKER_MOUSEDOWN;
                            break;
                        }
                        case MOUSEUP: {
                            eventType = MarkerEvent.MARKER_MOUSEUP;
                            break;
                        }
                        case ENTERED: {
                            eventType = MarkerEvent.MARKER_ENTERED;
                            break;
                        }
                        case EXITED: {
                            eventType = MarkerEvent.MARKER_EXITED;
                        }
                    }
                    MapView.this.fireEvent(new MarkerEvent(eventType, (Marker)mapCoordinateElement));
                }
            }
        }

        public void labelClicked(String name) {
            this.processLabelClicked(name, ClickType.LEFT);
        }

        public void labelMouseDown(String name) {
            this.processLabelClicked(name, ClickType.MOUSEDOWN);
        }

        public void labelMouseUp(String name) {
            this.processLabelClicked(name, ClickType.MOUSEUP);
        }

        public void labelDoubleClicked(String name) {
            this.processLabelClicked(name, ClickType.DOUBLE);
        }

        public void labelRightClicked(String name) {
            this.processLabelClicked(name, ClickType.RIGHT);
        }

        public void labelEntered(String name) {
            this.processLabelClicked(name, ClickType.ENTERED);
        }

        public void labelExited(String name) {
            this.processLabelClicked(name, ClickType.EXITED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLabelClicked(String name, ClickType clickType) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports label {} clicked {}", (Object)name, (Object)clickType);
            }
            Map map = MapView.this.mapCoordinateElements;
            synchronized (map) {
                MapCoordinateElement mapCoordinateElement;
                if (MapView.this.mapCoordinateElements.containsKey(name) && (mapCoordinateElement = (MapCoordinateElement)((WeakReference)MapView.this.mapCoordinateElements.get(name)).get()) instanceof MapLabel) {
                    EventType<MapLabelEvent> eventType = null;
                    switch (clickType) {
                        case LEFT: {
                            eventType = MapLabelEvent.MAPLABEL_CLICKED;
                            break;
                        }
                        case DOUBLE: {
                            eventType = MapLabelEvent.MAPLABEL_DOUBLECLICKED;
                            break;
                        }
                        case RIGHT: {
                            eventType = MapLabelEvent.MAPLABEL_RIGHTCLICKED;
                            break;
                        }
                        case MOUSEDOWN: {
                            eventType = MapLabelEvent.MAPLABEL_MOUSEDOWN;
                            break;
                        }
                        case MOUSEUP: {
                            eventType = MapLabelEvent.MAPLABEL_MOUSEUP;
                            break;
                        }
                        case ENTERED: {
                            eventType = MapLabelEvent.MAPLABEL_ENTERED;
                            break;
                        }
                        case EXITED: {
                            eventType = MapLabelEvent.MAPLABEL_EXITED;
                        }
                    }
                    MapView.this.fireEvent(new MapLabelEvent(eventType, (MapLabel)mapCoordinateElement));
                }
            }
        }

        public void zoomChanged(double newZoom) {
            long roundedZoom = Math.round(newZoom);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports zoom value {}", (Object)roundedZoom);
            }
            MapView.this.lastZoomFromMap.set(roundedZoom);
            MapView.this.setZoom(roundedZoom);
        }

        public void extentSelected(double latMin, double lonMin, double latMax, double lonMax) {
            Extent extent = Extent.forCoordinates(new Coordinate(latMin, lonMin), new Coordinate(latMax, lonMax));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports extend selected: {}", (Object)extent);
            }
            MapView.this.fireEvent(new MapViewEvent(MapViewEvent.MAP_EXTENT, extent));
        }

        public void extentChanged(double latMin, double lonMin, double latMax, double lonMax) {
            Extent extent = Extent.forCoordinates(new Coordinate(latMin, lonMin), new Coordinate(latMax, lonMax));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports extend change: {}", (Object)extent);
            }
            MapView.this.fireEvent(new MapViewEvent(MapViewEvent.MAP_BOUNDING_EXTENT, extent));
        }

        public void wheelEvent(double deltaY) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("JS reports wheel event: {}", (Object)deltaY);
            }
            MapView.this.setZoom(MapView.this.getZoom() - Math.signum(deltaY));
        }
    }
}

